\ 2006-08-16 EW adv2_6.fs
rom
include adv2_tasker.fs
include adv2_timeup.fs
include adv2_lcd.fs
: show.DT ( -- )
  year  @ p4! lcdtype
  month @ p2! lcdtype
  day   @ p2! lcdtype s" -" lcdtype
  hour  @ p2! lcdtype
  min   @ p2! lcdtype
  sec   @ p2! lcdtype
;
0     Constant PinSCL
1     Constant PinSDA
port1 Constant PortI2C
$E3   Constant PddrI2C
$9e   Constant i2c_addr_lm75
$a0   Constant i2c_addr_rtc
include adv2_i2c.fs
include adv2_i2c_rtc.fs
: clock-init ( -- )
  get.rtc
  year !
  bcd>dec month !
  bcd>dec day !
  bcd>dec hour !
  bcd>dec min !
  bcd>dec sec !
  drop \ Sec/100
;
include adv2_i2c_lm75.fs
: led0 ( -- ) 3 port1 bclr ;
: led1 ( -- ) 3 port1 bset ;
: job.tick
  tick @ $01 and IF led0 ELSE led1 ENDIF
  1 0 lcdpos show.T
;
: job.sec
  0 13 lcdpos sec @ p2! lcdtype
  timer @ dup lastsec @ - swap dup lastsec !
  sec @ min @ hour @ day @ month @ year @
  cr . . . . . . . .
;
: job.min
  cr ." running minute job ..."
  0 0 lcdpos show.DT
;
: job.hour
  cr ." running hour job ..."
;
: job.day
  cr ." running day job ..."
;
: job.month
  cr ." running month job ..."
;
: job.year
  cr ." running year job ..."
;
: init-loop ( -- )
  cr ." year month day hour min sec timer"
  ." timer-lastsec"
  clock-init
  timer @ cycles.tick + newtimer !
  lcdpage show.DT
  job.sec
;
ram
create Jobs ' job.tick ,
  ' job.sec , ' job.min , ' job.hour ,
  ' job.day , ' job.month , ' job.year ,
rom
: run task
  init-loop
  BEGIN
    tickover? IF timeup ENDIF
    7 0 DO
      I Flags btst IF
      I cells Jobs + @ execute
      I Flags bclr
      ENDIF
    LOOP
    pause
  AGAIN
;
ram