\ 2006-08-15 EW adv2_5.fs
rom
Variable Flags
Variable newtimer
Variable lastsec
500 Constant cycles.tick \ timerC cycles/tick
2   Constant ticks.sec   \ ticks/second
ram
create Counts &7 cells allot
create Limits ticks.sec c, 60 c, 60 c,
  24 c, 31 c, 12 c,
create MaxDay
  31 c, 28 c, 31 c, 30 c, 31 c, 30 c,
  31 c, 31 c, 30 c, 31 c, 30 c, 31 c,
rom
: tick  ( -- addr )         Counts   ;
: sec   ( -- addr ) 1 cells Counts + ;
: min   ( -- addr ) 2 cells Counts + ;
: hour  ( -- addr ) 3 cells Counts + ;
: day   ( -- addr ) 4 cells Counts + ;
: month ( -- addr ) 5 cells Counts + ;
: year  ( -- addr ) 6 cells Counts + ;
: tickover? ( -- ) newtimer @ timer @ -  0< ;
: leap_year ( year -- t/f )
  dup    4 mod 0=
  over 100 mod 0<> and
  swap 400 mod 0=  or
;
: length_of_month ( year month -- maxday )
  dup 1-                \ array starts at 0
  MaxDay + c@
  swap 2 = IF           \ if month == 2
    swap leap_year IF   \ and leap_year
      1+                \   month += 1
    ENDIF
  ELSE
    swap drop           \ remove year
  ENDIF
;
: timeup ( -- )
  cycles.tick newtimer +!
  0 Flags bset                  \ tickflag++
  1         Counts   +!         \ tick++
  \ for i in tick sec min hour day month
  6 0 DO
    I cells Counts +  @
    I Limits + c@ >= IF    \ if C[i] >= L[i]
      0 I cells Counts + !     \   C[i]=0;
      I 1+ Flags bset          \   F[i+1]++;
      1 I 1+ cells Counts + +! \   C[i+1]++;
    ENDIF                      \ endif
  LOOP
;
include adv2_lcd.fs
: show.DT ( -- )
  year  @ p4! lcdtype
  month @ 1+ p2! lcdtype
  day   @ 1+ p2! lcdtype s" -" lcdtype
  hour  @ p2! lcdtype
  min   @ p2! lcdtype
  sec   @ p2! lcdtype
; 
0     Constant PinSCL
1     Constant PinSDA
port1 Constant PortI2C
$E3   Constant PddrI2C
$9e   Constant i2c_addr_lm75
$a0   Constant i2c_addr_rtc
include adv2_i2c.fs
include adv2_i2c_rtc.fs
: clock-init ( -- )
  get.rtc
  year !
  bcd>dec 1- month ! \ offset 1 correction!
  bcd>dec 1- day !   \ offset 1 correction!
  bcd>dec hour !
  bcd>dec min !
  bcd>dec sec !
  drop \  Sec/100
;
include adv2_i2c_lm75.fs
: led0 ( -- ) 3 port1 bclr ;
: led1 ( -- ) 3 port1 bset ;
: job.tick
  tick @ $01 and IF led0 ELSE led1 ENDIF
  1 0 lcdpos show.T
;
: job.sec
  0 13 lcdpos sec @ p2! lcdtype
  timer @ dup lastsec @ - swap dup lastsec !
  7 1 DO I cells Counts + @ LOOP
  cr . 1+ . \ month offset 1 correction
  1+ .      \ day   offset 1 correction
  . . . . .
;
: job.min
  cr ." running minute job ..."
  0 0 lcdpos show.DT
;
: job.hour 
  cr ." running hour job ..."
;
: job.day
  cr ." running day job ..."
;
: job.month
  cr ." running month job ... "
  year @
  month @ 1+ \ month offset 1 correction
  length_of_month
  dup . ." new month limit"
  4 Limits + c!
;
: job.year
  cr ." running year job ..."
;
: init-loop
  cr ." year month day hour min sec timer"
  ." timer-lastsec"
  clock-init
  timer @ cycles.tick + newtimer !
  lcdpage show.DT
  job.sec
;
ram
create Jobs ' job.tick ,
  ' job.sec , ' job.min , ' job.hour ,
  ' job.day , ' job.month , ' job.year ,
rom
: run
  init-loop
  BEGIN
    tickover? IF timeup ENDIF
    7 0 DO
      I Flags btst IF
      I cells Jobs + @ execute
      I Flags bclr
      ENDIF
    LOOP
  key? UNTIL
;
ram
