\ ===+=== 1 ===+=== 2 ===+=== 3 ===+=== 4 ===+=== 5 ===+=== 6 ===+===
plotout.bas - Datei steuert Plotter (19-feb-2014 21:00 -jgt)

Dies ist ein Plotter-Programm fuer Mobile Basic unter Android.
Eine Datei mit Grafik-Befehlen steuert die Bildschirm-Grafik.
Die Datei plot.dat wird in /storage/emulated/0/gforth/home erwartet.
Dieser Ordner wird von Gforth fuer die Ausgabe benutzt.

Folgende Befehle werden erkannt:
    COLOR, CLEAR, LINE, RECT, OVAL, CIRCLE, PLOT, PAUSE, SHOW, END


function int(x as short) as short
    int=integer(x) & 0xFF
end function

sub gocolor     // {1} r g b a
    print "color"
    dim r,g,b,a as short
    get #1,r
    get #1,g
    get #1,b
    get #1,a
    setcolor r,g,b,a
end sub

sub goclear     // {2}
    print "clear"
    cls
end sub

sub goline      // {3} x1 y1 x2 y2 
    print "line"
    dim x1,y1,x2,y2 as short
    get #1,x1
    get #1,y1
    get #1,x2
    get #1,y2
    drawline x1,y1,x2,y2
end sub

sub gorect      // {4} x y w h f
    print "rect"
    dim x,y,w,h,f as short
    get #1,x
    get #1,y
    get #1,w
    get #1,h
    get #1,f
    if integer(f)=0 then
        drawrect x,y,w,h
    else
        fillrect x,y,w,h
    end if
end sub

sub gooval      // {5} x y w h f
    print "oval"
    dim x,y,w,h,f as short
    get #1,x
    get #1,y
    get #1,w
    get #1,h
    get #1,f
    if integer(f)=0 then
        drawoval x,y,w,h
    else
        filloval x,y,w,h
    end if
end sub

sub gocircle    // {6} x y r f
    print "circle"
    dim x,y,r,f as short
    get #1,x
    get #1,y
    get #1,r
    get #1,f
    if integer(f)=0 then
        drawcircle x,y,r
    else
        fillcircle x,y,r
    end if
end sub

sub goplot      // {7} x1 y1 [x2 y2 [...]] {0}
    print "plot"
    dim x,y as short
    dim endflag as boolean
    endflag=false
    while endflag=false
        get #1,x
        if x=short(0xAA00) then
            endflag=true
        else
            get #1,y
            plot x,y
        end if
    end while
end sub

sub gopause     // {8} s
    print "pause"
    dim s as short
    get #1,s
    sleep integer(s)*1000
end sub

sub goshow      // {9}
    print "show"
    repaint
end sub

sub main
    dim home,file as string
    dim ding as short
    dim item,cmd as integer
    dim basta,eflag as boolean

    graphics

    home="/storage/emulated/0/"
    file="gforth/home/deskplot.dat"

    open #1,home+file,"r"

    repeat
        repeat
            get #1,ding
            item=integer(ding)
        until item<0xAA00
        cmd=item & 0xFF
        if cmd=1 then
            call gocolor
        elseif cmd=2 then
            call goclear
        elseif cmd=3 then
            call goline
        elseif cmd=4 then
            call gorect
        elseif cmd=5 then
            call gooval
        elseif cmd=6 then
            call gocircle
        elseif cmd=7 then
            call goplot
        elseif cmd=8 then
            call gopause
        elseif cmd=9 then
            call goshow
        elseif cmd=10 then
            print "end"
            eflag=true
		end if
    until eflag=true

    close #1

 // basta=delete(home+file)
    if basta then
        print "file deleted"
    else
        print "file not deleted"
    end if
end sub

