\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ singen.fs - last edit: 03-jun-2013 12:00 -jgt
  cr ." included: singen.fs"

\                      S I N U S - G E N E R A T O R

        variable   timer                    \ Tonlängenzähler
        fvariable  phase                    \ Sinusphase

\ Neuen (einzelnen) Ton abarbeiten
: sound  ( r-step --)
        durat  timer !                      \ Tonlänge laden
        0e  phase f!                        \ Phase ab Null
        BEGIN
           phase f@ fsin                    \ ### Sinus ###
  square   IF f0>=
              IF .6e ELSE -.6e ENDIF        \ Rechtecksignal (square = 1)
           ENDIF
           volume s>f f*                    \ Amplitude erhöhen
           f>s dup w>buf dup .              \ in Wave-Datei schreiben
  mono     0= IF
  stereo         IF negate ENDIF            \ Raumklang
                 w>buf                      \ in 2. Kanal schreiben
              ELSE drop ENDIF
           fdup phase f@ f+  phase f!       \ Phase um step erhöhen
           timer @  1-  dup  timer !  0=    \ Tonlängenzähler 1-
        UNTIL                               \ Tonende?
        fdrop ;                             \ Phasenschritt löschen

\ Musikstück abarbeiten
: waves  ( --)
        tunelen 0                           \ Länge der Musik
        DO
           tune i cells + @                 \ Ton#
           dup    0 >                       \ Ton oder Pause?
           IF     1-                        \ Ton# --> Tabellenoffset
                  transpo +                 \ Tonhöhe-Verschiebung
                  fadr12 f@                 \ Phasenschritt (Tonhöhe)
           ELSE   drop 0e                   \ Pause, kein Schritt
           ENDIF  sound                     \ Ton erzeugen
        LOOP ;  

\ =======[ Ende von singen.fs ]===========================================
