\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ WAVER3-01.fs - last edit: 03-jun-2013 12:00 -jgt
\               _____________________________________
\              |                                     |
\              |        W a v e   E n g i n e        |   ============
\              |                                     |   Gforth 0.7.0
\              |            Version 3-01             |   ============
\              |_____________________________________|
\
\ Präambel:  Nachdem die komplexe, aber recht ordenlich laufende zweite
\ Version des Synthesizers "Wave Engine" durch ein Linux-Update instabil
\ geworden war, reifte der Entschluss, eine dritte Version (3-xx) neu zu
\ beginnen und dabei allen Code zugänglich zu machen.
\
\ Die hier vorligende Version 3-01 kann noch nicht viel, aber sie ist
\ imstande eine Partitur (Zahlentabelle) in eine abspielbare Wave-Datei
\ zu wandeln. Die Melodie ist einstimmig und verwendet nur gleich lange
\ reine Sinustöne (alternativ Rechtecktöne) und Pausen.
\
\ Den Sinustönen fehlen jegliche Obertöne. Die Rechtecktöne beinhalten
\ alle ungeradzahligen Harmonischen, nach oben hin abfallend. Künftig
\ sollen Klänge aus bis zu 16 Harmonischen zusammengesetzt werden.
\
\ Frei gewählt werden kann: ein-/zweikanalig, Stereoklang ein/aus,
\ Sinus/Rechteck, Lautstärke, Geschwindigkeit und Tonart-Verschiebung.
\ Kommentartext kann vor oder nach den Daten der Wave-Datei stehen.

       true  constant  mono          \ false: 2 Kanäle (mit/ohne Stereo)
      false  constant  stereo        \ true: Raumklang (mono = false)
      false  constant  square        \ true: Rechteck statt Sinus 
         70  constant  volume        \ Amplitude (70 okay, max 128)
       6000  constant  durat         \ Tonlänge (6000 okay)
       true  constant  prelist       \ true: Text vor (statt nach) Daten

    s" WAVER3-01"      2constant  version   \ Versionsbezeichnung
    s" WE-001.wav"     2constant  wavefile  \ Name der Ausgabedatei
    s" freqtab-1.fs"   included             \ Frequenztabelle
    s" wavgen.fs"      included             \ Wave-Generator
    s" partit.fs"      included             \ Partitur
    s" singen.fs"      included  cr cr      \ Sinus-Generator
\ ------------------------------------------------------------------------

\ Wave-Daten an dataChunk anhängen
: append-data  ( --)
        30000 nulls                         \ Pause vorab
              bytecnt @
           16 align-nulls                   \ Pausenende justieren
              waves                         \ Wave-Daten schreiben
              bytecnt @ 4 -                 \ 4 Pos. nach rechts
           16 align-nulls                   \ 0...15 Null-Bytes
              bytecnt @ dataend ! ;         \ Chunk-Ende merken

\ Text an listChunk anhängen
: append-text  ( --)
              s"   [ "              $>buf
              s" Wave Engine 3.01"  $>buf
              s" edit 130602-1420"  $>buf   \ editiert: ...
              s" comp "             $>buf   \ compiliert: ...
              timestamp                     \ aktuelles Datum
              s"  ]"                $>buf   \ Text-Ende
                                            \ Leerzeichen anhängen
              bytecnt @  4 -                \ 4 Pos. nach rechts
           16 align-spaces                  \ 0...15 Leerzeichen
              bytecnt @ listend ! ;         \ Chunk-Ende merken

: init  ( --) ;

\ ------------------------------------------------------------------------

\                      H A U P T - R O U T I N E

: build-wavefile  ( --)
                    init
                    create-outfile          \ Wave-Datei anlegen
                    build-waveChunk         \ erste 12 Bytes
                    build-formatChunk       \ weitere 24 Bytes
     prelist IF
                    build-listChunk         \ listChunk ohne Text
                      append-text           \ Text anhängen
                    build-dataChunk         \ dataChunk ohne Daten
                      append-data           \ Wave-Daten anhängen
             ELSE
                    build-dataChunk         \ dataChunk ohne Daten
                      append-data           \ Wave-Daten anhängen
                    build-listChunk         \ listChunk ohne Text
                      append-text           \ Text anhängen
             ENDIF
                    patch-waveChunkSize     \ Länge über alles
                    patch-dataChunkSize     \ Länge dataChunk
                    patch-listChunkSize     \ Länge listChunk
                    fillup                  \ Füllbytes
                    close-outfile ;         \ Wave-Datei schließen

\                              S T A R T
: go  build-wavefile
           ."  fertig! " .s f.s  cr ;       \ "<0> <0>" = Stacks okay

    version  type  ."   >>> Mit 'go' starten! <<< " cr cr

\ =======[ Ende von WAVER3-01.fs ]========================================
