\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ wavgen.fs - last edit: 03-jun-2013 12:00 -jgt
  cr ." included: wavgen.fs

\                       W A V E - G E N E R A T O R

            variable   tmp         \ n>buf, w>buf, c>buf temporaer
            variable   bufcnt      \ Pufferzaehler
            variable   bytecnt     \ Bytezaehler ueber alles
            variable   xcount      \ Zaehler fuer Punktausgabe
            variable   databeg     \ dataChunk Beginn
            variable   dataend     \ dataChunk Ende
            variable   listbeg     \ listChunk Beginn
            variable   listend     \ listChunk Ende
          0 value      wavefileID  \ Identifikationsnr der Wave-Datei
      22050 constant   bufsize     \ Groesze des Datenpuffers
            create     wbuffer bufsize allot

\ Wave-Datei anlegen.
: create-outfile  ( --)
            wavefile  R/W  BIN                ( c-addr 2 1)
            CREATE-FILE ( fileid ior) drop    ( ior=0 for success)
            to wavefileID ;

\ Daten in Wave-Datei schreiben.
: >file  ( addr len)  wavefileID  WRITE-FILE ( ior) drop ;

\ Schreibpuffer leeren und in Datei schreiben.
\ FLUSH-FILE leert auch den unsichtbaren Zwischenspeicher.
: bufflush  ( --)
            wbuffer bufcnt @ >file
            0 bufcnt !
            wavefileID FLUSH-FILE drop ;

\ Schreibpuffer ("wbuffer") laden und ggf. in die Wave-Datei uebertragen.
\ So lange die Daten nicht in den Puffer passen, wird der Puffer randvoll
\ gefuellt und sodann in die Wave-Datei entleert.
\ Dann wird der Datenrest in den Puffer geladen.
\ (Am Programmende wird der Puffer mit bufflush geleert.)
: $>buf  ( addr len --)
        BEGIN   bufsize bufcnt @ -  ( free) >r
                dup r@ >=
        WHILE   over wbuffer bufcnt @ + r@ move \ transfer
                swap r@ + swap  r> -
                wbuffer bufsize >file
                0 bufcnt !
        REPEAT  r> drop  dup
        IF      >r wbuffer bufcnt @ + r@ move   \ transfer
                bufcnt @ r@ + bufcnt !
                bytecnt @ r> + bytecnt !
        ELSE    2drop
        THEN ;

\ 4-byte-Wert in den Schreibpuffer schreiben.
: n>buf  ( u --)  tmp !                         \ bytes counted in bufcnt
            tmp 4 ( addr len) $>buf ;           \ schreiben

\ Wie n>buf, aber ohne bytecnt zu veraendern (fuer Patches).
: n>buf|  ( u --)                               \ bytecnt erhalten
            bytecnt @ >r n>buf r> bytecnt ! ;

\ 2-byte-Wert in den Schreibpuffer schreiben.
: w>buf  ( u --)  tmp !                         \ byte counted in bufcnt
            tmp 2 ( addr len) $>buf             \  schreiben
\ Fortschritt anzeigen:
            1 xcount +!
            xcount @ 100000 >= IF               \ alle 10000 Frames
            0 xcount ! ." ."  THEN ;            \  einen Punkt ausgeben

\ 1-byte-Wert in den Schreibpuffer schreiben.
: c>buf  ( u --)  tmp !                         \ byte counted in bufcnt
            tmp 1 ( addr len) $>buf ;           \  schreiben

\ Einen Wert 0...99 als zwei ASCII-Dezimalziffern schreiben.
\ Beispiel: 73 --> ($20 + 3) * $100 + ($20 + 7) = $2300 + $27 = $2327
\ Wegen "little endian" wird das Ergebnis $2327 als $27 $23 abgelegt.
: >ascii  ( u -- uw)
                100 mod  dup 10 mod  '0' + 256 *
                        swap 10 /  '0' + +  w>buf ;

\ Aktuelles Datum und Uhrzeit schreiben (Format: yymmdd-hhmmss).
: timestamp  ( --)
        TIME&DATE  ( sec min hour day month year)  100 mod
        >ascii ( yy)   >ascii ( mm)   >ascii ( dd)
        [char] -  c>buf
        >ascii ( hh)   >ascii ( mm)   drop ( ss) ;

\ Gegebene Anzahl oder ASCII-Nullen oder Leerzeichen schreiben.
: nulls   ( n --)  0 ?DO    0 c>buf  LOOP ;
: blanks  ( n --)  0 ?DO  $20 c>buf  LOOP ;

\ Pufferinhalt durch Nullen bzw. Leerzeichen so verlaengern, dasz der  
\ Pufferzaehler (cnt) modulo n = 0 ergibt.
: align-nulls   ( cnt n --)  dup >r  mod r@ swap - r> mod nulls ;
: align-spaces  ( cnt n --)  dup >r  mod r@ swap - r> mod blanks ;

\ Das "Resource Interchange File Format" ("RIFF") besteht aus mehreren
\ Abschnitten ("Chunks"), von denen hier nur vier Verwendung finden:
\ Wave, Format, Data und List.
\ Die ersten 44 Bytes sind vom Aufbau her festgelegt, nur die mit (*)
\ gekennzeichneten Werte sind veraenderlich. waveChunkSize ist die Laenge
\ ueber alles, aber ohne die ersten 8 Bytes (hier: 52-8=44). Auch die
\ Werte fuer Mono/Stereo sowie fuer Samples und Bytes pro Sekunde sind
\ veraenderlich. Werden Daten (je 2 byte bei Mono, 4 byte bei Stereo)
\ eingefuegt, so aendern sich die Laengenangaben entsprechend. Gleiches
\ gilt fuer Kommentartext. waveChunk und formatChunk stehen immer am
\ Anfang, dataChunk und listChunk koennen ggf. vertauscht werden.
\ ----------------------------[ Chunk 1 ]---------------------------------
\   0    00    52494646    'RIFF'                        groupID
\   4    04    54000000    44     (*)                    waveChunkSize
\   8    08    57415645    "WAVE"                        riffType
\ ----------------------------[ Chunk 2 ]---------------------------------
\  12    0C    666D7420    'fmt '                        formatChunkID
\  16    10    10000000    16                            formatChunkSize
\  20    14    0100        1           no compression    wFormatTag
\  22    16        0200    2      (*)  mono=1, stereo=2  wChannels
\  24    18    44AC0000    44100  (*)  draft: 11250      dwSamplesPerSec
\  28    1C    10B10200    176400 (*)  draft: 44100      dwAvgBytesPerSec
\  32    20    0400        4                             wBlockAlign
\  34    22        1000    16                            wBitsPerSample
\ ----------------------------[ Chunk 3 ]---------------------------------
\  36    24    64617461    'data'                        dataChunkID
\  40    28    00000000    0      (*)                    dataChunkSize
\ (44)  (3C)               (noch keine Daten)            (2 byte) 
\ ----------------------------[ Chunk 4 ]---------------------------------
\  44    3C    4C495354    'LIST'                        listChunkID
\  48    30    28000000    0      (*)                    listChunkSize
\ (52)  (34)               (noch kein Text)
\ ------------------------------------------------------------------------

\ Hier werden die Chunks aufgebaut. Die Daten im dataChunk werden durch
\ den Sinus-Generator per w>buf geschrieben, wodurch sich der Bytezaehler
\ bufcnt entsprechend erhoeht und listChunk vor sich herschiebt.
\ ----------------------------[ Chunk 1 ]---------------------------------
: build-waveChunk  ( --)
                       s" RIFF"  $>buf      \ groupID
                              0  n>buf      \ waveChunkSize (patch)
                       s" WAVE"  $>buf ;    \ riffType

\ ----------------------------[ Chunk 2 ]---------------------------------
: build-formatChunk  ( --)
                       s" fmt "  $>buf      \ formatChunkID
                             16  n>buf      \ formatChunkSize
                              1  w>buf      \ wFormatTag (no compr)
           
        mono  IF              1  w>buf      \ wChannels (mono)
      ( draft) 0   IF     11025  n>buf      \ dwSamplesPerSec
                          22050  n>buf      \ dwAvgBytesPerSec
                   ELSE   44100  n>buf      \ dwSamplesPerSec
                          88200  n>buf      \ dwAvgBytesPerSec
                   ENDIF
              ELSE            2  w>buf      \ wChannels (stereo)
      ( draft) 0   IF     11025  n>buf      \ dwSamplesPerSec
                          44100  n>buf      \ dwAvgBytesPerSec
                   ELSE   44100  n>buf      \ dwSamplesPerSec
                         176400  n>buf      \ dwAvgBytesPerSec
                   ENDIF
              ENDIF           4  w>buf      \ wBlockAlign
                             16  w>buf ;    \ wBitsPerSample

\ ----------------------------[ Chunk 3 ]---------------------------------
: build-dataChunk  ( --)
                       s" data"  $>buf      \ dataChunkID
                              0  n>buf      \ dataChunkSize (patch)
                      bytecnt @  databeg !  \ Position merken
                                ( ... ) ;   \ hier folgen Wave-Daten

\ ----------------------------[ Chunk 4 ]---------------------------------
: build-listChunk  ( --)
                       s" LIST"  $>buf      \ listChunkID
                              0  n>buf      \ listChunkSize (patch)
                      bytecnt @  listbeg !  \ Position merken
                                ( ... ) ;   \ hier folgt Text

\ ------------------------------------------------------------------------

\ Hier werden die Chunk-Laengen ueberschrieben (gepatcht).
\ Auf Pos. 4 steht die Laenge "ueber alles" (nach den ersten 8 byte).
\ Die Laenge des formatChunk ist unveraenderlich = 16.
\ Die Reihenfolge von dataChunk und listChunk ist waehlbar.
\ Auf Pos. 40 steht die Laenge der Wave-Daten bzw. des Textes.
\ Die Position des letzen Chunk (Text bzw. Wave-Daten) ist veraenderlich.

\ Laenge des waveChunk (ueber alles) setzen
: patch-waveChunkSize  ( --)
            bufflush
            4. waveFileID REPOSITION-FILE ( ior) drop
            bytecnt @ 8 - n>buf| ;
 
\ Laenge des dataChunk (Wave) setzen
: patch-dataChunkSize  ( --)
            bufflush
            databeg @ 4 - s>d waveFileID REPOSITION-FILE ( ior) drop
            dataend @ databeg @ - n>buf| ;

\ Laenge des listChunk (Text) setzen
: patch-listChunkSize  ( --)
            bufflush
            listbeg @ 4 - s>d waveFileID REPOSITION-FILE ( ior) drop
            listend @ listbeg @ - n>buf| ;


\ Datei mit Nullen beenden
: fillup  ( --)
            bufflush
            bytecnt @ s>d waveFileID REPOSITION-FILE ( ior) drop
            bytecnt @  16 align-nulls
            bufflush ;

\ Wave-Datei schlieszen
: close-outfile  ( --)
            wavefileID  CLOSE-FILE ( ior) drop ;

\ =======[ Ende von wavgen.fs ]===========================================
