\ 2008-10-18 EW filter_mean.fs
\ 
\ needs ans94/2x.frt
\
\ usage:
\ 10 filter_mean: F10
\ F10 mean_reset
\ ...
\ <value> F10 mean_addup
\ ...
\ F10 mean_eval . . d. . .
\ 
\ RAM layout (cells)
\   0  mean_sum
\   2  mean_N
\   3  mean_min
\   4  mean_max

: filter_mean:
  create ( id -- )
    ,      \ store id in dictionary entry
    heap , \ store next RAM addr
    5 cells allot \ create RAM space
  does>  ( -- id ram_addr )
    dup i@
    swap 1+ i@
;

\ offsets into ram_addr
0 constant mean_sum     
2 constant mean_N       
3 constant mean_min     
4 constant mean_max

: mean_sum+ ( mean_sum cells + ) noop ;	 
: mean_N+     mean_N   cells + ;	 
: mean_min+   mean_min cells + ;	 
: mean_max+   mean_max cells + ;         

\ reset filter
: mean_reset ( id ram_addr -- )
  >r
  0 s>d r@         2! \ mean_sum=0
  0     r@ mean_N+  ! \ mean_N=0
  r> drop \ ram_addr
  drop    \ id
;

: mean_eval
( id ram_addr -- id max d.sum min N>0 | id 0 )
  >r
  r@ mean_N+ @  0=  if
    0 \ N=0, no data
  else
    r@ mean_max+  @ \ mean_max
    r@           2@ \ mean_sum
    1
    r@ mean_N+    @ \ mean_N
    m*/             \ mean_sum*1/mean_N
    r@ mean_min+  @ \ mean_min
    r@ mean_N+    @ \ mean_N
  then
  r> drop \ ram_addr
;

: mean_addup ( x id ram_addr -- )
  >r
  drop \ id
  r@ mean_N+ @  0=  if
    dup  r@ mean_min+  !
    dup  r@ mean_max+  !
  else
    dup  r@ mean_min+ @  <  if
      dup  r@ mean_min+  !
    then
    dup  r@ mean_max+ @  >  if
      dup  r@ mean_max+  !
    then
  then
  s>d  r@ mean_sum+ 2@  d+
  r@ mean_sum+ 2! \
  1  r@ mean_N+  +!
  r> drop \ ram_addr
;

