\ 2008-04-15 EW   sensor.fs

\ words:
\ sensor:
\ data layout
\      id id of "sensor:"
\    addr address of hw sensor on bus
\    'get pointer to read function, result:
\         N Bytes 0 (ok) | -1 (err)
\ 'decode pointer to decode function, result:
\         scaled physical value(s) of sensor
\     a_0 zero order scaled correction (offset)

: sensor:
  create ( id i2c-addr 'get 'decode a_0 -- )
    \ keep order of arguments in (flash) memory
    >r >r >r >r , r> , r> , r> , r> ,
  does>  ( -- id skalierterWert ok/err )
    >r             ( -- )
      r@    i@     ( -- id )
    1 r@ +  i@     ( -- id i2c-addr )

    2 r@ +  i@     ( -- id i2c-addr 'get )
    execute        ( -- id xN..x1 ok | id err )
    0= if          ( -- id xN..x1 )
      3 r@ +  i@   ( -- id xN..x1 'decode )
      execute      ( -- id T*100 )
      4 r@ +  i@ + ( -- id T*100+a_0 )  
      0            ( -- id T*100+a_0 ok )
    else           ( -- id )
      -1           ( -- id error )
    then
    r> drop
;
