\ 2008-01-01 EW   flags.fs

\ use a variable as 16 bit variables

\ usage:
\ variable mainFlags
\ mainFlags 0 flag: Fdebug
\ Fdebug fset  \ set bit
\ Fdebug fclr  \ clear bit
\ Fdebug fset? \ true if bit is set
\ Fdebug fclr? \ true if bit is NOT set

\ create: store address and bitmask
\ does>:  fetch bitmask and address
: flag: create ( addr bit -- )
  1 swap lshift , ,
does>          ( -- bitmask addr )
  dup i@ swap 1+ i@
;

\ bitvalue, convert number of bit to mask
: bv ( bitnumber -- bitmask )
  1 swap lshift
;

: fset ( bitmask addr -- )
  dup @         ( mask addr value )
  rot           ( addr value mask )
  or            ( addr new-value )
  swap !
;

: fclr ( bitmask addr -- )
  dup @         ( mask addr value )
  rot           ( addr value mask )
  invert and    ( addr new-value )
  swap !
;


: fset? ( bitmask addr -- t/f )
  @ and 0<>
;

: fclr? ( bitmask addr -- t/f )
  @ and 0=
;

: ftgl ( bitmask addr -- )
  over over     ( mask addr mask addr )
  fset?
  if fclr else fset then
;
