\ server interface 

include tasker.fs
include lib.fs

library  myserver ./s.so
0 (int)  myserver telefon telefon ( -- rc )

10 constant alleserver
variable    anzahlserver   0 anzahlserver !

user     mein_telefon_rein 
user     mein_telefon_raus 

: normal
  stdin  
  stdout 
;

: sprechen
  mein_telefon_raus !
  mein_telefon_rein !
;

: mund_an_micro
  mein_telefon_raus @ to outfile-id
;

: ohr_an_hoerer
  mein_telefon_rein @ to infile-id 
;

: dereferenzieren 
  @ swap
  @ swap
;

: heb_ab 
  -9999
  begin
    drop       
    pause
    telefon    ( rc      ) 
    dup        ( rc rc   )
    -9999 <>   ( flag rc )
  until
  dup           ( rc rc        )
  cell +        ( rc rc+1 cell )
  dereferenzieren
  sprechen
;

: stask-key  mund_an_micro
             outfile-id flush-file drop
             BEGIN  pause 
                    ohr_an_hoerer
                    key? single-tasking? or  
             UNTIL
             ohr_an_hoerer
             (key) 
;

: stask-emit mund_an_micro
             task-emit ;

: stask-type mund_an_micro
             task-type ;

: auflegen
  mein_telefon_rein @ close-file drop
  mein_telefon_raus @ close-file drop
;

: einer_mehr 
  1 anzahlserver +!
;

: einer_weniger 
  -1 anzahlserver +!
;

: signoff 
  einer_weniger
  auflegen
  normal sprechen
  kill-task
;

: 1server
  normal sprechen
  create-input
  ['] stask-key  IS key
  ['] stask-emit IS emit
  ['] stask-type IS type
  heb_ab
  begin
    ['] quit catch
    0<> if
      .error cr
    then
    ['] false catch drop 
  again
;

: start1server
  einer_mehr
  4096 newtask activate
  1server
;

: nachstarten
  alleserver anzahlserver @ do
     start1server
  loop
;

: ausgefallen
  alleserver anzahlserver @ -
  dup 0> if
    ." Starte " dup . ." Server nach " cr 
  then

;

: mehrere 
  1 >=
;

: alleserverlos
  alleserver 0 do
     start1server
  loop
  normal sprechen
  begin
    ausgefallen mehrere if
      nachstarten
      normal sprechen
    then
    pause
    pause
    pause
    pause
  again
;
